using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace PI.ZB.N1200.ELearning.WinForms.Instructor
{                                        
    public partial class FNewInstructor : PI.FM.N000.Base.WinForms.Controls.Form
    {
        private PI.ZB.N1200.ELearning.BL.ZSBELearning _blZSBELearning = null;

        private PI.FM.N001.Account.BL.Account _blAccount = null;

        private PI.ZB.N1200.ELearning.BL.BO.Instructor _newInstructor = null;

        protected PI.ZB.N1200.ELearning.BL.ZSBELearning BLZSBELearning
        {
            get
            {
                if (_blZSBELearning == null)
                {
                    _blZSBELearning = new PI.ZB.N1200.ELearning.BL.ZSBELearning(this.Environment);
                }
                return _blZSBELearning;
            }
        }

        protected PI.FM.N001.Account.BL.Account BLAccount
        {
            get
            {
                if (_blAccount == null)
                {
                    _blAccount = new PI.FM.N001.Account.BL.Account(this.Environment);
                }
                return _blAccount;
            }
        }

        public FNewInstructor()
        {
            InitializeComponent();
        }

        public override void Initialize(Gemini.Core.WinForms.Interface.IPlugIn ParentPlugIn, Gemini.Core.WinForms.Interface.IEnvironment Environment)
        {
            base.Initialize(ParentPlugIn, Environment);
            _gButtonEditDALSchool.Initialize(BLZSBELearning.School, AddSchool, false);
        }

        public PI.ZB.N1200.ELearning.BL.BO.Instructor NewInstructor
        {
            get 
            {
                if (_newInstructor == null)
                {
                    if ((!String.IsNullOrEmpty(_gTextBoxForname.Text)) && (!String.IsNullOrEmpty(_gTextBoxSurename.Text)) && (!String.IsNullOrEmpty(_gTextBoxEmail.Text)) && (_gButtonEditDALSchool.ID.HasValue))
                    {
                        for (int loop = 1; loop < 81; loop++)
                        {
                            _newInstructor = BLZSBELearning.Instructor.New();
                            _newInstructor.Email = _gTextBoxEmail.Text.Trim();                          
                            _newInstructor.Forename = _gTextBoxForname.Text.Trim();
                            _newInstructor.Surename = _gTextBoxSurename.Text.Trim();
                            _newInstructor.SchoolID = _gButtonEditDALSchool.ID;

                            BLZSBELearning.Instructor.Save(_newInstructor);
                        }
                    }
                }

                return _newInstructor; 
            }
        }

        private void ButtonOK_Click(object sender, EventArgs e)
        {
            bool _isValid = true;
            List<string> _listMessage = new List<string>();

            _gTextBoxForname.ErrorText = null;
            _gTextBoxEmail.ErrorText = null;
            _gTextBoxSurename.ErrorText = null;
            _gButtonEditDALSchool.ErrorText = null;


            if (String.IsNullOrEmpty(_gTextBoxEmail.Text))
            {
                _isValid = false;
                _gTextBoxEmail.ErrorText = String.Format(Gemini.Dictionary.Text.WarningValueIsMandatory.Value, _gLabelEmail.PlainText);
                _listMessage.Add(String.Format(Gemini.Dictionary.Text.WarningValueIsMandatory.Value, _gLabelEmail.PlainText));
            }
            else
            {
                _gTextBoxEmail.Text = _gTextBoxEmail.Text.Trim().ToLower();

                if (BLAccount.User.View.RestoreByEmail(_gTextBoxEmail.Text) != null)
                {
                    _isValid = false;
                    _gTextBoxEmail.ErrorText = String.Format(Gemini.Dictionary.Text.Email.AlreadyRegistered.Value, _gLabelEmail.PlainText);
                    _listMessage.Add(String.Format(Gemini.Dictionary.Text.Email.AlreadyRegistered.Value, _gLabelEmail.PlainText));
                }
                else
                {
                    if (!Gemini.Core.BL.Utility.Validate.IsValidEmail(_gTextBoxEmail.Text))
                    {
                        _isValid = false;
                        _gTextBoxEmail.ErrorText = String.Format(Gemini.Dictionary.Text.Email.NotValid.Value, _gLabelEmail.PlainText);
                        _listMessage.Add(String.Format(Gemini.Dictionary.Text.Email.NotValid.Value, _gLabelEmail.PlainText));
                    }
                }
            }

            if (String.IsNullOrEmpty(_gTextBoxForname.Text))
            {
                _gTextBoxForname.ErrorText = String.Format(Gemini.Dictionary.Text.WarningValueIsMandatory.Value, _gLabelForename.PlainText);
                _listMessage.Add(String.Format(Gemini.Dictionary.Text.WarningValueIsMandatory.Value, _gLabelForename.PlainText));
                _isValid = false;
            }

            if (String.IsNullOrEmpty(_gTextBoxSurename.Text))
            {
                _gTextBoxSurename.ErrorText = String.Format(Gemini.Dictionary.Text.WarningValueIsMandatory.Value, _gLabelSurename.PlainText);
                _listMessage.Add(String.Format(Gemini.Dictionary.Text.WarningValueIsMandatory.Value, _gLabelSurename.PlainText));
                _isValid = false;
            }

            if (!_gButtonEditDALSchool.ID.HasValue)
            {
                _gButtonEditDALSchool.ErrorText = String.Format(Gemini.Dictionary.Text.WarningValueIsMandatory.Value, _gLabelSchool.PlainText);
                _listMessage.Add(String.Format(Gemini.Dictionary.Text.WarningValueIsMandatory.Value, _gLabelSchool.PlainText));
                _isValid = false;
            }

            if (_isValid)
            {
                DialogResult = DialogResult.OK;
                Close();
            }
            else
            {
                DialogResult = DialogResult.None;
                PI.FM.N000.Base.WinForms.Controls.FDefaultMessage _dialog = new PI.FM.N000.Base.WinForms.Controls.FDefaultMessage();
                _dialog.SetMessage = _listMessage;
                _dialog.ShowDialog();
            }
        }

        private void ButtonCancel_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
            Close();
        }

        private Gemini.Core.BL.Interface.BO.IBaseUnique<long?> AddSchool()
        {
            FM.N000.Base.WinForms.Classes.Param _param = new FM.N000.Base.WinForms.Classes.Param(Gemini.Core.WinForms.Interface.ShowMode.ModalWindow);
            BL.BO.School.Search _search = new BL.BO.School.Search();
            Environment.WindowsHandler.Show(BL.Dictionary.WinFormsName, new Gemini.Core.WinForms.Base.AccessDescription(BL.Dictionary.Objects.UI.SchoolList), _param, _search);

            return _param.Object;
        }
    }
}